/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.content;

import filenet.vw.toolkit.admin.VWConfigActionCommand;
import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.VWConfigContextMenu;
import filenet.vw.toolkit.admin.VWConfigRegionNode;
import filenet.vw.toolkit.admin.VWConfigVWServiceNode;
import filenet.vw.toolkit.admin.content.IVWContentViewMouseListener;
import filenet.vw.toolkit.admin.content.VWConfigContentViewPane;
import filenet.vw.toolkit.admin.content.VWConfigIcon;
import filenet.vw.toolkit.design.canvas.config.VWDesignerRegionNode;
import filenet.vw.toolkit.design.canvas.config.VWDesignerVWServiceNode;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.AWTException;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;

class VWConfigContentViewMouseAndKeyListener
extends MouseAdapter
implements KeyListener {
    private VWConfigContentViewPane m_contentView = null;
    private IVWContentViewMouseListener m_contentViewMouseListener = null;
    private VWSessionInfo m_vwSessionInfo = null;
    private static Robot robot = null;

    public VWConfigContentViewMouseAndKeyListener(VWConfigContentViewPane contentPane, IVWContentViewMouseListener contentViewMouseListener, VWSessionInfo sessionInfo) {
        this.m_contentView = contentPane;
        this.m_contentViewMouseListener = contentViewMouseListener;
        this.m_vwSessionInfo = sessionInfo;
    }

    public void keyTyped(KeyEvent event) {
    }

    public void keyPressed(KeyEvent event) {
        Object obj = event.getSource();
        if (obj != null && obj instanceof VWConfigIcon) {
            int keyCode = event.getKeyCode();
            if (keyCode == 65) {
                int modifiers = event.getModifiers();
                if ((modifiers & 8) != 0) {
                    this.m_contentView.changeFocus(((VWConfigIcon)obj).m_node);
                    this.showPopup((VWConfigIcon)obj, 10, 10);
                }
            } else if (keyCode == 121) {
                int modifiers = event.getModifiers();
                if ((modifiers & 1) != 0) {
                    robot.keyPress(27);
                    robot.keyRelease(27);
                    this.m_contentView.changeFocus(((VWConfigIcon)obj).m_node);
                    this.showPopup((VWConfigIcon)obj, 10, 10);
                }
            } else if (keyCode == 10 || keyCode == 32) {
                this.m_contentView.changeFocus(((VWConfigIcon)obj).m_node);
                this.performAction((VWConfigIcon)obj);
            }
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    public void mouseClicked(MouseEvent event) {
        Object obj = event.getSource();
        if (obj instanceof VWConfigIcon && event.getClickCount() == 2) {
            this.performAction((VWConfigIcon)obj);
        }
    }

    public void mousePressed(MouseEvent event) {
        Object obj = event.getSource();
        if (obj != null && obj instanceof VWConfigIcon) {
            VWConfigIcon aIcon = (VWConfigIcon)obj;
            VWConfigBaseNode focus = aIcon.m_node;
            this.m_contentView.changeFocus(focus);
        }
    }

    public void mouseReleased(MouseEvent event) {
        Object obj;
        if (event.isPopupTrigger() && (obj = event.getSource()) instanceof VWConfigIcon) {
            VWConfigIcon aIcon = (VWConfigIcon)obj;
            aIcon.doClick();
            Point p = event.getPoint();
            this.showPopup(aIcon, p.x, p.y);
        }
    }

    public void performAction(VWConfigIcon aIcon) {
        VWConfigBaseNode focus = aIcon.m_node;
        int nodeType = focus.getType();
        if (nodeType == 19) {
            VWConfigRegionNode rNode = (VWConfigRegionNode)focus;
            if (rNode.getSessionInfo() == null) {
                this.m_contentView.actionPerformed(new ActionEvent(this, 1001, VWConfigActionCommand.ACMD_LOGON));
                this.m_contentView.requestFocus(aIcon);
            } else {
                this.m_contentViewMouseListener.displayContent(focus);
            }
        } else if (nodeType == 5) {
            this.m_contentView.actionPerformed(new ActionEvent(this, 1001, VWConfigActionCommand.ACMD_COMPONENT_PROPERTIES));
        } else if (nodeType == 1 || nodeType == 2) {
            this.m_contentView.actionPerformed(new ActionEvent(this, 1001, VWConfigActionCommand.ACMD_QUEUE_PROPERTIES));
        } else if (nodeType == 3) {
            this.m_contentView.actionPerformed(new ActionEvent(this, 1001, VWConfigActionCommand.ACMD_ROSTER_PROPERTIES));
        } else if (nodeType == 4) {
            this.m_contentView.actionPerformed(new ActionEvent(this, 1001, VWConfigActionCommand.ACMD_EVENTLOG_PROPERTIES));
        } else if (nodeType == 6) {
            this.m_contentView.actionPerformed(new ActionEvent(this, 1001, VWConfigActionCommand.ACMD_APPSPACE_PROPERTIES));
        } else if ((nodeType & 0x10) == 16) {
            this.m_contentViewMouseListener.displayContent(focus);
        }
    }

    protected void releaseResources() {
        this.m_contentView = null;
        this.m_contentViewMouseListener = null;
    }

    private void showPopup(VWConfigIcon aIcon, int x, int y) {
        aIcon.setSelected(true);
        VWConfigBaseNode focus = aIcon.m_node;
        this.m_contentView.changeFocus(focus);
        String actionCmd = aIcon.getActionCommand();
        VWConfigContextMenu mi = null;
        if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_FOLDER) == 0) {
            mi = new VWConfigContextMenu(this.m_vwSessionInfo, 17, this.m_contentView, focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_CONSOLE_ROOT) == 0) {
            mi = new VWConfigContextMenu(this.m_vwSessionInfo, 17, this.m_contentView, focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_SYSTEM) == 0) {
            VWConfigVWServiceNode svcNode = (VWConfigVWServiceNode)aIcon.m_node;
            if (svcNode != null && svcNode instanceof VWDesignerVWServiceNode) {
                return;
            }
            mi = new VWConfigContextMenu(this.m_vwSessionInfo, 1, this.m_contentView, focus);
            mi.setSystemMenus((VWConfigVWServiceNode)focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_REGION) == 0) {
            VWConfigRegionNode rNode = (VWConfigRegionNode)aIcon.m_node;
            if (rNode.getSessionInfo() == null) {
                mi = new VWConfigContextMenu(this.m_vwSessionInfo, 5, this.m_contentView, focus);
            } else {
                mi = rNode instanceof VWDesignerRegionNode ? new VWConfigContextMenu(rNode.getSessionInfo(), 3, this.m_contentView, focus) : new VWConfigContextMenu(rNode.getSessionInfo(), 2, this.m_contentView, focus);
                mi.setRegionMenus((VWConfigRegionNode)focus);
            }
        } else {
            mi = VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_SERVER) == 0 ? new VWConfigContextMenu(this.m_vwSessionInfo, 4, this.m_contentView, focus) : (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_COMP_QUEUE_FOLDER) == 0 ? new VWConfigContextMenu(this.m_vwSessionInfo, 6, this.m_contentView, focus) : (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_USER_QUEUE_FOLDER) == 0 ? new VWConfigContextMenu(this.m_vwSessionInfo, 8, this.m_contentView, focus) : (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_WORK_QUEUE_FOLDER) == 0 ? new VWConfigContextMenu(this.m_vwSessionInfo, 7, this.m_contentView, focus) : (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_WORK_QUEUE) == 0 || VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_USER_QUEUE) == 0 ? new VWConfigContextMenu(this.m_vwSessionInfo, 13, this.m_contentView, focus) : (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_COMP_QUEUE) == 0 ? new VWConfigContextMenu(this.m_vwSessionInfo, 12, this.m_contentView, focus) : (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_ROSTER_FOLDER) == 0 ? new VWConfigContextMenu(this.m_vwSessionInfo, 9, this.m_contentView, focus) : (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_ROSTER) == 0 ? new VWConfigContextMenu(this.m_vwSessionInfo, 14, this.m_contentView, focus) : (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_EVENTLOG_FOLDER) == 0 ? new VWConfigContextMenu(this.m_vwSessionInfo, 10, this.m_contentView, focus) : (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_EVENTLOG) == 0 ? new VWConfigContextMenu(this.m_vwSessionInfo, 15, this.m_contentView, focus) : (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_APPSPACE_FOLDER) == 0 ? new VWConfigContextMenu(this.m_vwSessionInfo, 11, this.m_contentView, focus) : (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_APPSPACE) == 0 ? new VWConfigContextMenu(this.m_vwSessionInfo, 16, this.m_contentView, focus) : new VWConfigContextMenu(this.m_vwSessionInfo, 18, this.m_contentView, focus))))))))))));
        }
        if (mi != null) {
            mi.show(aIcon, x, y);
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    robot = new Robot();
                }
                catch (AWTException aWTException) {
                    // empty catch block
                }
                return null;
            }
        });
    }
}

